#version 330 core
#extension GL_ARB_explicit_attrib_location: enable

layout(location = 0) in vec3 vertexPositionIn;
layout(location = 1) in vec2 uvIn;
layout(location = 2) in vec4 rgbaLightIn;
layout(location = 3) in int renderFlags;
layout(location = 4) in vec2 flowVector;
layout(location = 5) in int waterFlagsIn;
layout(location = 6) in int colormapData;

uniform vec3 origin;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float viewDistance;

#include vertexflagbits.ash
#include vertexwarp.vsh


void main(void)
{
	vec4 worldPos = vec4(vertexPositionIn + origin, 1.0);
	
	float div = ((waterFlagsIn & (1<<27)) > 0) ? 90 : 5;
	
	if ((waterFlagsIn & 1) == 1) {
		worldPos = applyLiquidWarping((waterFlagsIn & 0x2000000) == 0, worldPos, div);
	}
		
	vec4 cameraPos = modelViewMatrix * worldPos;
	
	gl_Position = projectionMatrix * cameraPos;
	
	// Distance fade out
	float a = length(worldPos.xz) / viewDistance;
	gl_Position.w -= max(0, (a-0.75)*5);
}